"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openModal = openModal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _map_embeddables_singleton = require("../../embeddable/map_embeddables_singleton");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function openModal() {
  const {
    openModal: reactOverlaysOpenModal
  } = (0, _public.createReactOverlays)((0, _kibana_services.getCore)());
  const modalSession = reactOverlaysOpenModal( /*#__PURE__*/_react.default.createElement(SynchronizeMovementModal, {
    onClose: () => modalSession.close()
  }));
}
class SynchronizeMovementModal extends _react.Component {
  _renderSwitches() {
    const mapPanels = _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels();
    const synchronizedPanels = mapPanels.filter(mapPanel => {
      return mapPanel.getIsMovementSynchronized();
    });
    return mapPanels.map(mapPanel => {
      const hasErrors = synchronizedPanels.length === 1 && mapPanel.getIsMovementSynchronized();
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressedSwitch",
        key: mapPanel.id,
        isInvalid: hasErrors,
        error: hasErrors ? [_i18n.i18n.translate('xpack.maps.synchronizeMovementModal.onlyOneMapSelectedError', {
          defaultMessage: 'Select another map to synchronize map movement'
        })] : []
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: mapPanel.getTitle(),
        checked: mapPanel.getIsMovementSynchronized(),
        onChange: event => {
          const isChecked = event.target.checked;
          if (!isChecked && synchronizedPanels.length === 2) {
            // Auto uncheck last 2 switches when second to last switch is unchecked
            synchronizedPanels.forEach(it => {
              it.setIsMovementSynchronized(false);
            });
          } else if (isChecked && mapPanels.length === 2) {
            // Auto check switches when there is only a pair of maps
            mapPanels.forEach(it => {
              it.setIsMovementSynchronized(true);
            });
          } else {
            mapPanel.setIsMovementSynchronized(isChecked);
          }
          this.forceUpdate();
        },
        compressed: true
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('xpack.maps.synchronizeMovementAction.title', {
      defaultMessage: 'Synchronize map movement'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, this._renderSwitches()));
  }
}