"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompatible = isCompatible;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/visualizations-plugin/public");
var _public2 = require("@kbn/lens-plugin/public");
var _constants = require("../../../common/constants");
var _is_legacy_map = require("../../legacy_visualizations/is_legacy_map");
var _map_embeddables_singleton = require("../../embeddable/map_embeddables_singleton");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isCompatible(api) {
  var _api$getSavedVis;
  if (!_map_embeddables_singleton.mapEmbeddablesSingleton.hasMultipleMaps()) {
    return false;
  }
  return (0, _presentationPublishing.apiIsOfType)(api, _constants.MAP_SAVED_OBJECT_TYPE) || (0, _public2.isLensApi)(api) && ((_api$getSavedVis = api.getSavedVis()) === null || _api$getSavedVis === void 0 ? void 0 : _api$getSavedVis.visualizationType) === 'lnsChoropleth' || (0, _public.apiHasVisualizeConfig)(api) && (0, _is_legacy_map.isLegacyMapApi)(api);
}