"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openModal = openModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _map_embeddables_singleton = require("../../embeddable/map_embeddables_singleton");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function openModal(title) {
  const {
    openModal: reactOverlaysOpenModal
  } = (0, _public.createReactOverlays)((0, _kibana_services.getCore)());
  const modalSession = reactOverlaysOpenModal( /*#__PURE__*/_react.default.createElement(FilterByMapExtentModal, {
    onClose: () => modalSession.close(),
    title: title
  }));
}
class FilterByMapExtentModal extends _react.Component {
  _renderSwitches() {
    return _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().map(mapPanel => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        display: "columnCompressedSwitch",
        key: mapPanel.id
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        label: mapPanel.getTitle(),
        checked: mapPanel.getIsFilterByMapExtent(),
        onChange: event => {
          const isChecked = event.target.checked;
          mapPanel.setIsFilterByMapExtent(isChecked);

          // only a single map can create map bound filter at a time
          // disable all other map panels from creating map bound filter
          if (isChecked) {
            _map_embeddables_singleton.mapEmbeddablesSingleton.getMapPanels().forEach(it => {
              if (it.id !== mapPanel.id && it.getIsFilterByMapExtent()) {
                it.setIsFilterByMapExtent(false);
              }
            });
          }
          this.forceUpdate();
        },
        compressed: true,
        "data-test-subj": `filterByMapExtentSwitch${mapPanel.id}`
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, this.props.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, this._renderSwitches()));
  }
}