"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _kibana_services = require("./kibana_services");
var _routes = require("./routes");
var _constants = require("../common/constants");
var _load_layer_wizards = require("./classes/layers/wizards/load_layer_wizards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setAppChrome() {
  if (!(0, _kibana_services.getMapsCapabilities)().save) {
    (0, _kibana_services.getCoreChrome)().setBadge({
      text: _i18n.i18n.translate('xpack.maps.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.maps.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save maps'
      }),
      iconType: 'glasses'
    });
  }
  const mapUrl = (0, _kibana_services.getDocLinks)().links.maps.guide;
  (0, _kibana_services.getCoreChrome)().setHelpExtension({
    appName: 'Maps',
    links: [{
      linkType: 'documentation',
      href: `${mapUrl}`
    }, {
      linkType: 'github',
      title: '[Maps]',
      labels: ['Team:Geo']
    }]
  });
}
async function renderApp({
  element,
  history,
  onAppLeave,
  setHeaderActionMenu,
  theme$
}, {
  coreStart,
  AppUsageTracker,
  savedObjectsTagging
}) {
  const stateTransfer = (0, _kibana_services.getEmbeddableService)().getStateTransfer();
  (0, _load_layer_wizards.registerLayerWizards)();
  setAppChrome();
  function renderMapApp(routeProps) {
    const {
      embeddableId,
      originatingApp,
      valueInput,
      originatingPath
    } = stateTransfer.getIncomingEditorState(_constants.APP_ID) || {};
    let mapEmbeddableInput;
    if (routeProps.match.params.savedMapId) {
      mapEmbeddableInput = {
        savedObjectId: routeProps.match.params.savedMapId
      };
    } else if (valueInput) {
      mapEmbeddableInput = valueInput;
    }
    return /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: (0, _kibana_services.getCore)()
    }, /*#__PURE__*/_react.default.createElement(_routes.MapPage, {
      mapEmbeddableInput: mapEmbeddableInput,
      embeddableId: embeddableId,
      onAppLeave: onAppLeave,
      setHeaderActionMenu: setHeaderActionMenu,
      stateTransfer: stateTransfer,
      originatingApp: originatingApp,
      originatingPath: originatingPath,
      history: history,
      key: routeProps.match.params.savedMapId ? routeProps.match.params.savedMapId : 'new'
    }));
  }
  const I18nContext = (0, _kibana_services.getCoreI18n)().Context;
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(AppUsageTracker, null, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: coreStart,
    toMountPoint: _public.toMountPoint,
    savedObjectsTagging,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/map/:savedMapId`,
    render: renderMapApp
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `/map`,
    render: renderMapApp
  }), "// Redirect other routes to list, or if hash-containing, their non-hash equivalents", /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: ``,
    render: ({
      location: {
        pathname,
        hash
      }
    }) => {
      if (hash) {
        // Remove leading hash
        const newPath = hash.substr(1);
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: newPath
        });
      } else if (pathname === '/' || pathname === '') {
        return /*#__PURE__*/_react.default.createElement(_routes.ListPage, {
          history: history,
          stateTransfer: stateTransfer
        });
      } else {
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: "/"
        });
      }
    }
  }))))))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
}