"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertISODateToNanoPrecision = convertISODateToNanoPrecision;
exports.subtractMillisecondsFromDate = subtractMillisecondsFromDate;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertISODateToNanoPrecision(date) {
  const dateParts = date.split('.');
  const fractionSeconds = dateParts.length === 2 ? dateParts[1].replace('Z', '') : '';
  const fractionSecondsInNanos = fractionSeconds.length !== 9 ? fractionSeconds.padEnd(9, '0') : fractionSeconds;
  return `${dateParts[0]}.${fractionSecondsInNanos}Z`;
}
function subtractMillisecondsFromDate(date, milliseconds) {
  var _dateMath$parse;
  const dateInNano = convertISODateToNanoPrecision(date);
  const dateParts = dateInNano.split('.');
  const nanoPart = dateParts[1].substring(3, dateParts[1].length); // given 123456789Z => 456789Z

  const isoDate = (_dateMath$parse = _datemath.default.parse(date)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.subtract(milliseconds, 'ms').toISOString();
  return `${isoDate === null || isoDate === void 0 ? void 0 : isoDate.replace('Z', nanoPart)}`;
}