"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceLogsLocatorDefinition = exports.TRACE_LOGS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _infra = require("./infra");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRACE_LOGS_LOCATOR_ID = exports.TRACE_LOGS_LOCATOR_ID = 'TRACE_LOGS_LOCATOR';
class TraceLogsLocatorDefinition {
  constructor(locators) {
    (0, _defineProperty2.default)(this, "id", TRACE_LOGS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const infraLogsLocator = this.locators.get(_infra.INFRA_LOGS_LOCATOR_ID);
      if (infraLogsLocator) {
        return infraLogsLocator.getLocation({
          ...params,
          filter: (0, _helpers.getTraceQuery)(params).query
        });
      }
      const {
        time
      } = params;
      const allDatasetsLocator = this.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
      return allDatasetsLocator.getLocation({
        query: (0, _helpers.getTraceQuery)(params),
        ...(time ? {
          timeRange: {
            from: (0, _helpers.getTimeRangeStartFromTime)(time),
            to: (0, _helpers.getTimeRangeEndFromTime)(time)
          }
        } : {})
      });
    });
    this.locators = locators;
  }
}
exports.TraceLogsLocatorDefinition = TraceLogsLocatorDefinition;