"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnformattedResourceFields = void 0;
var constants = _interopRequireWildcard(require("../../common/constants"));
var _get_field_from_flattened_doc = require("./get_field_from_flattened_doc");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUnformattedResourceFields = doc => {
  const serviceName = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.SERVICE_NAME_FIELD);
  const hostName = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.HOST_NAME_FIELD);
  const agentName = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.AGENT_NAME_FIELD);
  const orchestratorClusterName = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ORCHESTRATOR_CLUSTER_NAME_FIELD);
  const orchestratorResourceId = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ORCHESTRATOR_RESOURCE_ID_FIELD);
  const orchestratorNamespace = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ORCHESTRATOR_NAMESPACE_FIELD);
  const containerName = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.CONTAINER_NAME_FIELD);
  const containerId = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.CONTAINER_ID_FIELD);
  const cloudInstanceId = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.CLOUD_INSTANCE_ID_FIELD);
  return {
    [constants.SERVICE_NAME_FIELD]: serviceName,
    [constants.HOST_NAME_FIELD]: hostName,
    [constants.AGENT_NAME_FIELD]: agentName,
    [constants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: orchestratorClusterName,
    [constants.ORCHESTRATOR_RESOURCE_ID_FIELD]: orchestratorResourceId,
    [constants.ORCHESTRATOR_NAMESPACE_FIELD]: orchestratorNamespace,
    [constants.CONTAINER_NAME_FIELD]: containerName,
    [constants.CONTAINER_ID_FIELD]: containerId,
    [constants.CLOUD_INSTANCE_ID_FIELD]: cloudInstanceId
  };
};
exports.getUnformattedResourceFields = getUnformattedResourceFields;