"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStacktraceFields = void 0;
var constants = _interopRequireWildcard(require("../../common/constants"));
var _get_field_from_flattened_doc = require("./get_field_from_flattened_doc");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStacktraceFields = doc => {
  const errorStackTrace = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ERROR_STACK_TRACE);
  const errorExceptionStackTrace = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ERROR_EXCEPTION_STACKTRACE);
  const errorLogStackTrace = (0, _get_field_from_flattened_doc.getFieldFromDoc)(doc, constants.ERROR_LOG_STACKTRACE);
  return {
    [constants.ERROR_STACK_TRACE]: errorStackTrace,
    [constants.ERROR_EXCEPTION_STACKTRACE]: errorExceptionStackTrace,
    [constants.ERROR_LOG_STACKTRACE]: errorLogStackTrace
  };
};
exports.getStacktraceFields = getStacktraceFields;