"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHoverActions = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _translations = require("../components/common/translations");
var _use_discover_action = require("./use_discover_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHoverActions = ({
  field,
  value
}) => {
  const filterForText = (0, _translations.actionFilterForText)(value);
  const filterOutText = (0, _translations.actionFilterOutText)(value);
  const actions = (0, _use_discover_action.useDiscoverActionsContext)();
  const [columnAdded, setColumnAdded] = (0, _react.useState)(false);
  return (0, _react.useMemo)(() => [{
    id: 'addToFilterAction',
    tooltipContent: filterForText,
    iconType: 'plusInCircle',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter(field, value, '+'),
    display: true
  }, {
    id: 'removeFromFilterAction',
    tooltipContent: filterOutText,
    iconType: 'minusInCircle',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter(field, value, '-'),
    display: true
  }, {
    id: 'filterForFieldPresentAction',
    tooltipContent: _translations.flyoutHoverActionFilterForFieldPresentText,
    iconType: 'filter',
    onClick: () => (actions === null || actions === void 0 ? void 0 : actions.addFilter) && actions.addFilter('_exists_', field, '+'),
    display: true
  }, {
    id: 'toggleColumnAction',
    tooltipContent: _translations.flyoutHoverActionToggleColumnText,
    iconType: 'listAdd',
    onClick: () => {
      if (actions) {
        if (columnAdded) {
          var _actions$removeColumn;
          actions === null || actions === void 0 ? void 0 : (_actions$removeColumn = actions.removeColumn) === null || _actions$removeColumn === void 0 ? void 0 : _actions$removeColumn.call(actions, field);
        } else {
          var _actions$addColumn;
          actions === null || actions === void 0 ? void 0 : (_actions$addColumn = actions.addColumn) === null || _actions$addColumn === void 0 ? void 0 : _actions$addColumn.call(actions, field);
        }
        setColumnAdded(!columnAdded);
      }
    },
    display: true
  }, {
    id: 'copyToClipboardAction',
    tooltipContent: _translations.flyoutHoverActionCopyToClipboardText,
    iconType: 'copyClipboard',
    onClick: () => (0, _eui.copyToClipboard)(value),
    display: true
  }], [filterForText, filterOutText, actions, field, value, columnAdded]);
};
exports.useHoverActions = useHoverActions;