"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentColumnTooltip = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _translations = require("../../common/translations");
var _hover_popover = require("../../common/hover_popover");
var _tooltip_button = require("./tooltip_button");
var _field_with_token = require("./field_with_token");
var constants = _interopRequireWildcard(require("../../../../common/constants"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentColumnTooltip = ({
  column,
  headerRowHeight
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const spacingCSS = (0, _react2.css)`
    margin-bottom: ${euiTheme.size.s};
  `;
  return /*#__PURE__*/_react.default.createElement(_hover_popover.HoverPopover, {
    button: /*#__PURE__*/_react.default.createElement(_tooltip_button.TooltipButtonComponent, {
      displayText: column.displayAsText,
      headerRowHeight: headerRowHeight
    }),
    title: _translations.contentLabel
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '230px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: spacingCSS
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.contentHeaderTooltipParagraph1)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: spacingCSS
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.contentHeaderTooltipParagraph2)), /*#__PURE__*/_react.default.createElement(_field_with_token.FieldWithToken, {
    field: constants.ERROR_MESSAGE_FIELD
  }), /*#__PURE__*/_react.default.createElement(_field_with_token.FieldWithToken, {
    field: constants.EVENT_ORIGINAL_FIELD,
    iconType: "tokenEvent"
  })));
};
exports.ContentColumnTooltip = ContentColumnTooltip;