"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightField = HighlightField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _hover_popover_action = require("./hover_popover_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HighlightFieldDescription = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./highlight_field_description'))));
function HighlightField({
  useBadge = false,
  field,
  formattedValue,
  icon,
  label,
  value,
  width,
  ...props
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return formattedValue && value ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    direction: "column",
    gutterSize: "none"
  }, props), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    css: (0, _react.css)`
                color: ${euiTheme.colors.darkShade};
              `,
    size: "xxxs"
  }, /*#__PURE__*/_react2.default.createElement("span", null, label))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(HighlightFieldDescription, {
    fieldName: field
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_hover_popover_action.HoverActionPopover, {
    title: value,
    value: value,
    field: field
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "xs"
  }, icon && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, icon), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextTruncate, {
    text: formattedValue,
    truncation: "end",
    width: width
  }, truncatedText => useBadge ? /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, truncatedText) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
    // Value returned from formatFieldValue is always sanitized
    ,
    dangerouslySetInnerHTML: {
      __html: truncatedText
    }
  }))))))) : null;
}