"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = FlyoutHeader;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_doc_detail = require("../../hooks/use_doc_detail");
var _log_level = require("../common/log_level");
var _timestamp = require("./sub_components/timestamp");
var constants = _interopRequireWildcard(require("../../../common/constants"));
var _translations = require("../common/translations");
var _hover_popover_action = require("./sub_components/hover_popover_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FlyoutHeader({
  doc
}) {
  const hasTimestamp = Boolean(doc[constants.TIMESTAMP_FIELD]);
  const hasLogLevel = Boolean(doc[constants.LOG_LEVEL_FIELD]);
  const hasBadges = hasTimestamp || hasLogLevel;
  const {
    field,
    value
  } = (0, _use_doc_detail.getMessageWithFallbacks)(doc);
  const hasMessageField = field && value;
  const hasFlyoutHeader = hasMessageField || hasBadges;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.flyoutContentLabel
  });
  const accordionTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.flyoutContentLabel));
  const logLevelAndTimestamp = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, hasBadges && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "m",
    justifyContent: "flexEnd"
  }, doc[constants.LOG_LEVEL_FIELD] && /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: doc[constants.LOG_LEVEL_FIELD],
    field: constants.LOG_LEVEL_FIELD
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_log_level.LogLevel, {
    level: doc[constants.LOG_LEVEL_FIELD],
    renderInFlyout: true,
    dataTestSubj: "logsExplorerFlyoutLogLevel"
  }))), hasTimestamp && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_timestamp.Timestamp, {
    timestamp: doc[constants.TIMESTAMP_FIELD]
  }))));
  const contentField = hasMessageField && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "logsExplorerFlyoutLogMessage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "none",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, field)), logLevelAndTimestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_hover_popover_action.HoverActionPopover, {
    value: value,
    field: field,
    anchorPosition: "downCenter",
    display: "block"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 100,
    paddingSize: "m",
    isCopyable: true,
    language: "txt",
    fontSize: "m"
  }, value)))));
  return hasFlyoutHeader ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: accordionTitle,
    paddingSize: "m",
    initialIsOpen: true,
    "data-test-subj": `logsExplorerFlyoutHeaderSection${_translations.flyoutContentLabel}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    "data-test-subj": "logsExplorerFlyoutDetail"
  }, hasMessageField ? contentField : logLevelAndTimestamp)) : null;
}