"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectorPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _data_source_selection = require("../../../../common/data_source_selection");
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const panelStyle = {
  width: _constants.DATA_SOURCE_SELECTOR_WIDTH
};
const SelectorPopover = ({
  children,
  onClick,
  selection,
  ...props
}) => {
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const buttonStyles = (0, _utils.getPopoverButtonStyles)({
    fullWidth: isMobile
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, (0, _extends2.default)({
    id: _constants.POPOVER_ID,
    "data-test-subj": "dataSourceSelectorPopover",
    anchorPosition: isMobile ? 'downCenter' : 'downLeft',
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      css: buttonStyles,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onClick,
      fullWidth: isMobile,
      "data-test-subj": "dataSourceSelectorPopoverButton"
    }, (0, _data_source_selection.isDataViewSelection)(selection) ? /*#__PURE__*/_react.default.createElement(DataViewPopoverContent, {
      dataViewSelection: selection
    }) : /*#__PURE__*/_react.default.createElement(DatasetPopoverContent, {
      datasetSelection: selection
    })),
    panelPaddingSize: "none",
    buffer: 8
  }, isMobile && {
    display: 'block'
  }, props), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    css: panelStyle,
    "data-test-subj": "dataSourceSelectorContent"
  }, children));
};
exports.SelectorPopover = SelectorPopover;
const DataViewPopoverContent = ({
  dataViewSelection
}) => {
  const {
    name
  } = dataViewSelection.selection.dataView;
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, name);
};
const DatasetPopoverContent = ({
  datasetSelection
}) => {
  var _parentIntegration$na, _parentIntegration$ve;
  const {
    iconType,
    parentIntegration
  } = datasetSelection.selection.dataset;
  const title = datasetSelection.selection.dataset.getFullTitle();
  const hasIntegration = typeof parentIntegration === 'object';
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType
  }) : hasIntegration ? /*#__PURE__*/_react.default.createElement(_public.PackageIcon, {
    packageName: (_parentIntegration$na = parentIntegration.name) !== null && _parentIntegration$na !== void 0 ? _parentIntegration$na : '',
    version: (_parentIntegration$ve = parentIntegration.version) !== null && _parentIntegration$ve !== void 0 ? _parentIntegration$ve : '1.0.0',
    icons: parentIntegration.icons,
    size: "m",
    tryApi: true
  }) : null, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, title));
};