"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HoverPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HoverPopover = ({
  children,
  button,
  title
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const leaveTimer = (0, _react.useRef)(null);
  const clearTimer = () => {
    if (leaveTimer.current) {
      clearTimeout(leaveTimer.current);
    }
  };
  const onMouseEnter = () => {
    clearTimer();
    setIsPopoverOpen(true);
  };
  const onMouseLeave = () => {
    leaveTimer.current = setTimeout(() => setIsPopoverOpen(false), 100);
  };
  (0, _react.useEffect)(() => {
    return () => {
      clearTimer();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "s",
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, title), children));
};
exports.HoverPopover = HoverPopover;