"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterInButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/data-plugin/public");
var _translations = require("./translations");
var _use_virtual_column_services = require("../../hooks/use_virtual_column_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterInButton = ({
  property,
  value
}) => {
  const ariaFilterForText = (0, _translations.actionFilterForText)(value);
  const serviceContext = (0, _use_virtual_column_services.useVirtualColumnServiceContext)();
  const filterManager = serviceContext === null || serviceContext === void 0 ? void 0 : serviceContext.data.query.filterManager;
  const dataView = serviceContext.dataView;
  const onFilterForAction = () => {
    if (filterManager != null) {
      const filter = (0, _public.generateFilters)(filterManager, property, [value], '+', dataView);
      filterManager.addFilters(filter);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: "addToFilterAction"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    iconType: "plusInCircle",
    "aria-label": ariaFilterForText,
    onClick: onFilterForAction,
    "data-test-subj": `dataTableCellAction_addToFilterAction_${property}`
  }, _translations.filterForText));
};
exports.FilterInButton = FilterInButton;