"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleDatasetSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _datasets = require("../datasets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SingleDatasetSelection {
  constructor(dataset) {
    var _dataset$parentIntegr, _dataset$parentIntegr2, _dataset$parentIntegr3;
    (0, _defineProperty2.default)(this, "selectionType", void 0);
    (0, _defineProperty2.default)(this, "selection", void 0);
    this.selectionType = 'single';
    this.selection = {
      name: (_dataset$parentIntegr = dataset.parentIntegration) === null || _dataset$parentIntegr === void 0 ? void 0 : _dataset$parentIntegr.name,
      title: (_dataset$parentIntegr2 = dataset.parentIntegration) === null || _dataset$parentIntegr2 === void 0 ? void 0 : _dataset$parentIntegr2.title,
      version: (_dataset$parentIntegr3 = dataset.parentIntegration) === null || _dataset$parentIntegr3 === void 0 ? void 0 : _dataset$parentIntegr3.version,
      dataset
    };
  }
  toDataviewSpec() {
    return this.selection.dataset.toDataviewSpec();
  }
  toPlainSelection() {
    return {
      selectionType: this.selectionType,
      selection: {
        name: this.selection.name,
        title: this.selection.title,
        version: this.selection.version,
        dataset: this.selection.dataset.toPlain()
      }
    };
  }
  static fromSelection(selection) {
    const {
      name,
      title,
      version,
      dataset
    } = selection;

    // Attempt reconstructing the integration object
    const integration = name && version ? {
      name,
      title,
      version
    } : undefined;
    const datasetInstance = _datasets.Dataset.create(dataset, integration);
    return SingleDatasetSelection.create(datasetInstance);
  }
  static create(dataset) {
    return new SingleDatasetSelection(dataset);
  }
}
exports.SingleDatasetSelection = SingleDatasetSelection;