"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_ID_FIELD = exports.TIMESTAMP_FIELD = exports.SMART_FALLBACK_FIELDS = exports.SERVICE_NAME_FIELD = exports.RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.MESSAGE_FIELD = exports.LOG_LEVEL_FIELD = exports.LOG_FILE_PATH_FIELD = exports.LOGS_EXPLORER_PROFILE_ID = exports.HOST_NAME_FIELD = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.EVENT_ORIGINAL_FIELD = exports.ERROR_STACK_TRACE = exports.ERROR_MESSAGE_FIELD = exports.ERROR_LOG_STACKTRACE = exports.ERROR_EXCEPTION_STACKTRACE = exports.DEGRADED_DOCS_FIELD = exports.DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_COLUMNS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = exports.DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_DATASET_FIELD = exports.CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD = exports.CONTAINER_NAME_FIELD = exports.CONTAINER_ID_FIELD = exports.CLOUD_REGION_FIELD = exports.CLOUD_PROVIDER_FIELD = exports.CLOUD_PROJECT_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = exports.AGENT_NAME_FIELD = exports.ACTIONS_COLUMN_WIDTH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGS_EXPLORER_PROFILE_ID = exports.LOGS_EXPLORER_PROFILE_ID = 'logs-explorer';

// Fields constants
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const HOST_NAME_FIELD = exports.HOST_NAME_FIELD = 'host.name';
const LOG_LEVEL_FIELD = exports.LOG_LEVEL_FIELD = 'log.level';
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const ERROR_MESSAGE_FIELD = exports.ERROR_MESSAGE_FIELD = 'error.message';
const EVENT_ORIGINAL_FIELD = exports.EVENT_ORIGINAL_FIELD = 'event.original';
const TRACE_ID_FIELD = exports.TRACE_ID_FIELD = 'trace.id';
const LOG_FILE_PATH_FIELD = exports.LOG_FILE_PATH_FIELD = 'log.file.path';
const DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_NAMESPACE_FIELD = 'data_stream.namespace';
const DATASTREAM_DATASET_FIELD = exports.DATASTREAM_DATASET_FIELD = 'data_stream.dataset';

// Resource Fields
const AGENT_NAME_FIELD = exports.AGENT_NAME_FIELD = 'agent.name';
const CLOUD_PROVIDER_FIELD = exports.CLOUD_PROVIDER_FIELD = 'cloud.provider';
const CLOUD_REGION_FIELD = exports.CLOUD_REGION_FIELD = 'cloud.region';
const CLOUD_AVAILABILITY_ZONE_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = 'cloud.availability_zone';
const CLOUD_PROJECT_ID_FIELD = exports.CLOUD_PROJECT_ID_FIELD = 'cloud.project.id';
const CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = 'cloud.instance.id';
const SERVICE_NAME_FIELD = exports.SERVICE_NAME_FIELD = 'service.name';
const ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = 'orchestrator.cluster.name';
const ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = 'orchestrator.resource.id';
const ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = 'orchestrator.namespace';
const CONTAINER_NAME_FIELD = exports.CONTAINER_NAME_FIELD = 'container.name';
const CONTAINER_ID_FIELD = exports.CONTAINER_ID_FIELD = 'container.id';

// Degraded Docs
const DEGRADED_DOCS_FIELD = exports.DEGRADED_DOCS_FIELD = 'ignored_field_values';

// Error Stacktrace
const ERROR_STACK_TRACE = exports.ERROR_STACK_TRACE = 'error.stack_trace';
const ERROR_EXCEPTION_STACKTRACE = exports.ERROR_EXCEPTION_STACKTRACE = 'error.exception.stacktrace';
const ERROR_LOG_STACKTRACE = exports.ERROR_LOG_STACKTRACE = 'error.log.stacktrace';

// Virtual column fields
const CONTENT_FIELD = exports.CONTENT_FIELD = 'content';
const RESOURCE_FIELD = exports.RESOURCE_FIELD = 'resource';

// Sizing
const DATA_GRID_COLUMN_WIDTH_SMALL = exports.DATA_GRID_COLUMN_WIDTH_SMALL = 240;
const DATA_GRID_COLUMN_WIDTH_MEDIUM = exports.DATA_GRID_COLUMN_WIDTH_MEDIUM = 320;
const ACTIONS_COLUMN_WIDTH = exports.ACTIONS_COLUMN_WIDTH = 80;
const RESOURCE_FIELD_CONFIGURATION = exports.RESOURCE_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: RESOURCE_FIELD,
  fallbackFields: [HOST_NAME_FIELD, SERVICE_NAME_FIELD],
  width: DATA_GRID_COLUMN_WIDTH_MEDIUM
};
const CONTENT_FIELD_CONFIGURATION = exports.CONTENT_FIELD_CONFIGURATION = {
  type: 'smart-field',
  smartField: CONTENT_FIELD,
  fallbackFields: [MESSAGE_FIELD]
};
const SMART_FALLBACK_FIELDS = exports.SMART_FALLBACK_FIELDS = {
  [CONTENT_FIELD]: CONTENT_FIELD_CONFIGURATION,
  [RESOURCE_FIELD]: RESOURCE_FIELD_CONFIGURATION
};

// UI preferences
const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = [RESOURCE_FIELD_CONFIGURATION, CONTENT_FIELD_CONFIGURATION];
const DEFAULT_ROWS_PER_PAGE = exports.DEFAULT_ROWS_PER_PAGE = 100;

// List of prefixes which needs to be filtered out for Display in Content Column
const FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = exports.FILTER_OUT_FIELDS_PREFIXES_FOR_CONTENT = ['_',
// Filter fields like '_id', '_score'
'@timestamp', 'agent.', 'elastic_agent.', 'data_stream.', 'ecs.', 'host.', 'container.', 'cloud.', 'kubernetes.', 'orchestrator.', 'log.', 'service.'];
const DEFAULT_ALLOWED_DATA_VIEWS = exports.DEFAULT_ALLOWED_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];
const DEFAULT_ALLOWED_LOGS_DATA_VIEWS = exports.DEFAULT_ALLOWED_LOGS_DATA_VIEWS = ['logs', 'auditbeat', 'filebeat', 'winlogbeat'];