"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ExceptionListClient", {
  enumerable: true,
  get: function () {
    return _exception_list_client.ExceptionListClient;
  }
});
Object.defineProperty(exports, "ListClient", {
  enumerable: true,
  get: function () {
    return _list_client.ListClient;
  }
});
Object.defineProperty(exports, "ListsErrorWithStatusCode", {
  enumerable: true,
  get: function () {
    return _error_with_status_code.ErrorWithStatusCode;
  }
});
exports.plugin = exports.config = void 0;
var _config = require("./config");
var _list_client = require("./services/lists/list_client");
var _exception_list_client = require("./services/exception_lists/exception_list_client");
var _error_with_status_code = require("./error_with_status_code");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ // exporting these since it's required at top level in siem plugin
const config = exports.config = {
  schema: _config.ConfigSchema
};
const plugin = async initializerContext => {
  const {
    ListPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new ListPlugin(initializerContext);
};
exports.plugin = plugin;