"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extract = void 0;
var _persistable_state = require("../persistable_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const extract = state => {
  const typedState = state;

  // by-reference embeddable
  if (!('attributes' in typedState) || typedState.attributes === undefined) {
    // No references to extract for by-reference embeddable since all references are stored with by-reference saved object
    return {
      state,
      references: []
    };
  }

  // by-value embeddable
  const {
    attributes,
    references
  } = (0, _persistable_state.extractReferences)({
    attributes: typedState.attributes
  });
  return {
    state: {
      ...state,
      attributes
    },
    references
  };
};
exports.extract = extract;