"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadLicense = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _telemetry_opt_in = require("../../components/telemetry_opt_in");
var _telemetry = require("../../lib/telemetry");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UploadLicense extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isOptingInToTelemetry: false
    });
    (0, _defineProperty2.default)(this, "onOptInChange", isOptingInToTelemetry => {
      this.setState({
        isOptingInToTelemetry
      });
    });
    (0, _defineProperty2.default)(this, "send", acknowledge => {
      const file = this.file;
      const fr = new FileReader();
      fr.onload = ({
        target: {
          result
        }
      }) => {
        if (this.state.isOptingInToTelemetry) {
          var _this$props$telemetry;
          (_this$props$telemetry = this.props.telemetry) === null || _this$props$telemetry === void 0 ? void 0 : _this$props$telemetry.telemetryService.setOptIn(true);
        }
        this.props.uploadLicense(result, this.props.currentLicenseType, acknowledge);
      };
      fr.readAsText(file);
    });
    (0, _defineProperty2.default)(this, "cancel", () => {
      this.props.uploadLicenseStatus({});
    });
    (0, _defineProperty2.default)(this, "handleFile", ([file]) => {
      if (file) {
        this.props.addUploadErrorMessage('');
      }
      this.file = file;
    });
    (0, _defineProperty2.default)(this, "submit", event => {
      event.preventDefault();
      if (this.file) {
        this.send();
      } else {
        this.props.addUploadErrorMessage( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.licenseMgmt.uploadLicense.licenseFileNotSelectedErrorMessage",
          defaultMessage: "You must select a license file."
        }));
      }
    });
  }
  componentDidMount() {
    this.props.setBreadcrumb('upload');
    this.props.addUploadErrorMessage('');
  }
  acknowledgeModal() {
    const {
      needsAcknowledgement,
      messages: [firstLine, ...messages] = []
    } = this.props;
    if (!needsAcknowledgement) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModalTitle",
        defaultMessage: "Confirm License Upload"
      }),
      onCancel: this.cancel,
      onConfirm: () => this.send(true),
      cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModal.cancelButtonLabel",
        defaultMessage: "Cancel"
      }),
      confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.confirmModal.confirmButtonLabel",
        defaultMessage: "Confirm"
      })
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, firstLine), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, messages.map(message => /*#__PURE__*/_react.default.createElement("li", {
      key: message
    }, message))))));
  }
  errorMessage() {
    const {
      errorMessage
    } = this.props;
    if (!errorMessage) {
      return null;
    }
    return [errorMessage];
  }
  render() {
    const {
      currentLicenseType,
      applying,
      telemetry,
      history
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      alignment: "center",
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadLicenseTitle",
      defaultMessage: "Upload your license"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), this.acknowledgeModal(), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.licenseKeyTypeDescription",
      defaultMessage: "Your license key is a JSON file with a signature attached."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.replacingCurrentLicenseWarningMessage",
      defaultMessage: "Uploading a license will replace your current {currentLicenseType} license.",
      values: {
        currentLicenseType: /*#__PURE__*/_react.default.createElement("strong", null, currentLicenseType.toUpperCase())
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      isInvalid: !!this.errorMessage(),
      error: this.errorMessage()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      fullWidth: true,
      id: "licenseFile",
      initialPromptText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.uploadLicense.selectLicenseFileDescription",
        defaultMessage: "Select or drag your license file"
      }),
      onChange: this.handleFile
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), (0, _telemetry.shouldShowTelemetryOptIn)(telemetry) && /*#__PURE__*/_react.default.createElement(_telemetry_opt_in.TelemetryOptIn, {
      isOptingInToTelemetry: this.state.isOptingInToTelemetry,
      onOptInChange: this.onOptInChange,
      telemetry: telemetry
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
      "data-test-subj": "cancelUploadButton"
    }, (0, _public.reactRouterNavigate)(history, '/home')), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "uploadLicenseButton",
      fill: true,
      isLoading: applying,
      onClick: this.submit
    }, applying ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadingButtonLabel",
      defaultMessage: "Uploading\u2026"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.uploadLicense.uploadButtonLabel",
      defaultMessage: "Upload"
    })))))));
  }
}
exports.UploadLicense = UploadLicense;