"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LENS_HEATMAP_RENDERER = exports.LENS_HEATMAP_ID = exports.LEGEND_FUNCTION = exports.HEATMAP_GRID_FUNCTION = exports.GROUP_ID = exports.FUNCTION_NAME = exports.DEFAULT_PALETTE_NAME = exports.CHART_SHAPES = exports.CHART_NAMES = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_HEATMAP_RENDERER = exports.LENS_HEATMAP_RENDERER = 'lens_heatmap_renderer';
const LENS_HEATMAP_ID = exports.LENS_HEATMAP_ID = 'lnsHeatmap';
const DEFAULT_PALETTE_NAME = exports.DEFAULT_PALETTE_NAME = 'temperature';
const groupLabel = _i18n.i18n.translate('xpack.lens.heatmap.groupLabel', {
  defaultMessage: 'Heatmap'
});
const CHART_SHAPES = exports.CHART_SHAPES = {
  HEATMAP: 'heatmap'
};
const CHART_NAMES = exports.CHART_NAMES = {
  heatmap: {
    shapeType: CHART_SHAPES.HEATMAP,
    icon: _chartIcons.IconChartHeatmap,
    label: _i18n.i18n.translate('xpack.lens.heatmap.heatmapLabel', {
      defaultMessage: 'Heat map'
    }),
    groupLabel
  }
};
const GROUP_ID = exports.GROUP_ID = {
  X: 'x',
  Y: 'y',
  CELL: 'cell'
};
const FUNCTION_NAME = exports.FUNCTION_NAME = 'heatmap';
const LEGEND_FUNCTION = exports.LEGEND_FUNCTION = 'heatmap_legend';
const HEATMAP_GRID_FUNCTION = exports.HEATMAP_GRID_FUNCTION = 'heatmap_grid';