"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gaugeTitlesByType = exports.LENS_GAUGE_ID = exports.GROUP_ID = void 0;
var _common = require("@kbn/expression-gauge-plugin/common");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LENS_GAUGE_ID = exports.LENS_GAUGE_ID = 'lnsGauge';
const GROUP_ID = exports.GROUP_ID = {
  METRIC: 'metric',
  MIN: 'min',
  MAX: 'max',
  GOAL: 'goal'
};
const gaugeTitlesByType = exports.gaugeTitlesByType = {
  [_common.GaugeShapes.HORIZONTAL_BULLET]: _i18n.i18n.translate('xpack.lens.gaugeHorizontal.gaugeLabel', {
    defaultMessage: 'Horizontal Bullet'
  }),
  [_common.GaugeShapes.VERTICAL_BULLET]: _i18n.i18n.translate('xpack.lens.gaugeVertical.gaugeLabel', {
    defaultMessage: 'Vertical Bullet'
  }),
  [_common.GaugeShapes.SEMI_CIRCLE]: _i18n.i18n.translate('xpack.lens.gaugeSemiCircle.gaugeLabel', {
    defaultMessage: 'Semi-circular Gauge'
  }),
  [_common.GaugeShapes.ARC]: _i18n.i18n.translate('xpack.lens.gaugeArc.gaugeLabel', {
    defaultMessage: 'Arc Gauge'
  }),
  [_common.GaugeShapes.CIRCLE]: _i18n.i18n.translate('xpack.lens.gaugeCircle.gaugeLabel', {
    defaultMessage: 'Circular Gauge'
  })
};