"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTransposeColumnFilterHandler = exports.createGridSortingConfig = exports.createGridResizeHandler = exports.createGridHideHandler = exports.createGridFilterHandler = exports.buildSchemaDetectors = void 0;
var _sortPredicates = require("@kbn/sort-predicates");
var _i18n = require("@kbn/i18n");
var _transpose_helpers = require("../../../../common/expressions/datatable/transpose_helpers");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGridResizeHandler = (columnConfig, setColumnConfig, onEditAction) => eventData => {
  const originalColumnId = (0, _transpose_helpers.getOriginalId)(eventData.columnId);
  // directly set the local state of the component to make sure the visualization re-renders immediately,
  // re-layouting and taking up all of the available space.
  setColumnConfig({
    ...columnConfig,
    columns: columnConfig.columns.map(column => {
      if (column.columnId === eventData.columnId || column.originalColumnId === originalColumnId) {
        return {
          ...column,
          width: eventData.width
        };
      }
      return column;
    })
  });
  return onEditAction({
    action: 'resize',
    columnId: originalColumnId,
    width: eventData.width
  });
};
exports.createGridResizeHandler = createGridResizeHandler;
const createGridHideHandler = (columnConfig, setColumnConfig, onEditAction) => eventData => {
  const originalColumnId = (0, _transpose_helpers.getOriginalId)(eventData.columnId);
  // directly set the local state of the component to make sure the visualization re-renders immediately
  setColumnConfig({
    ...columnConfig,
    columns: columnConfig.columns.map(column => {
      if (column.columnId === eventData.columnId || column.originalColumnId === originalColumnId) {
        return {
          ...column,
          hidden: true
        };
      }
      return column;
    })
  });
  return onEditAction({
    action: 'toggle',
    columnId: originalColumnId
  });
};
exports.createGridHideHandler = createGridHideHandler;
const createGridFilterHandler = (tableRef, onClickValue) => (_field, value, colIndex, rowIndex, negate = false) => {
  const data = {
    negate,
    data: [{
      row: rowIndex,
      column: colIndex,
      value,
      table: tableRef.current
    }]
  };
  onClickValue(data);
};
exports.createGridFilterHandler = createGridFilterHandler;
const createTransposeColumnFilterHandler = (onClickValue, untransposedDataRef) => (bucketValues, negate = false) => {
  if (!untransposedDataRef.current) return;
  const originalTable = untransposedDataRef.current;
  const data = {
    negate,
    data: bucketValues.map(({
      originalBucketColumn,
      value
    }) => {
      const columnIndex = originalTable.columns.findIndex(c => c.id === originalBucketColumn.id);
      const rowIndex = originalTable.rows.findIndex(r => r[originalBucketColumn.id] === value);
      return {
        row: rowIndex,
        column: columnIndex,
        value,
        table: originalTable
      };
    })
  };
  onClickValue(data);
};
exports.createTransposeColumnFilterHandler = createTransposeColumnFilterHandler;
const createGridSortingConfig = (sortBy, sortDirection, onEditAction) => ({
  columns: !sortBy || sortDirection === 'none' ? [] : [{
    id: sortBy,
    direction: sortDirection
  }],
  onSort: sortingCols => {
    const newSortValue = sortingCols.length <= 1 ? sortingCols[0] : sortingCols[1];
    const isNewColumn = sortBy !== ((newSortValue === null || newSortValue === void 0 ? void 0 : newSortValue.id) || '');
    const nextDirection = newSortValue ? newSortValue.direction : 'none';
    return onEditAction({
      action: 'sort',
      columnId: nextDirection !== 'none' || isNewColumn ? newSortValue === null || newSortValue === void 0 ? void 0 : newSortValue.id : undefined,
      direction: nextDirection
    });
  }
});
exports.createGridSortingConfig = createGridSortingConfig;
function isRange(meta) {
  var _meta$params;
  return (meta === null || meta === void 0 ? void 0 : (_meta$params = meta.params) === null || _meta$params === void 0 ? void 0 : _meta$params.id) === 'range';
}
function getColumnType({
  columnConfig,
  columnId,
  lookup
}) {
  var _columnConfig$columns, _lookup$columnId, _lookup$columnId2, _lookup$columnId2$met;
  const sortingHint = (_columnConfig$columns = columnConfig.columns.find(col => col.columnId === columnId)) === null || _columnConfig$columns === void 0 ? void 0 : _columnConfig$columns.sortingHint;
  return sortingHint !== null && sortingHint !== void 0 ? sortingHint : isRange((_lookup$columnId = lookup[columnId]) === null || _lookup$columnId === void 0 ? void 0 : _lookup$columnId.meta) ? 'range' : (_lookup$columnId2 = lookup[columnId]) === null || _lookup$columnId2 === void 0 ? void 0 : (_lookup$columnId2$met = _lookup$columnId2.meta) === null || _lookup$columnId2$met === void 0 ? void 0 : _lookup$columnId2$met.type;
}
const buildSchemaDetectors = (columns, columnConfig, table, formatters) => {
  const columnsReverseLookup = (0, _helpers.buildColumnsMetaLookup)(table);
  return columns.map(column => {
    const schemaType = getColumnType({
      columnConfig,
      columnId: column.id,
      lookup: columnsReverseLookup
    });
    const sortingCriteria = (0, _sortPredicates.getSortingCriteria)(schemaType, column.id, formatters === null || formatters === void 0 ? void 0 : formatters[column.id]);
    return {
      sortTextAsc: _i18n.i18n.translate('xpack.lens.datatable.sortTextAsc', {
        defaultMessage: 'Sort Ascending'
      }),
      sortTextDesc: _i18n.i18n.translate('xpack.lens.datatable.sortTextDesc', {
        defaultMessage: 'Sort Descending'
      }),
      icon: '',
      type: column.id,
      detector: () => 1,
      // This is the actual logic that is used to sort the table
      comparator: (_a, _b, direction, {
        aIndex,
        bIndex
      }) => sortingCriteria(table.rows[aIndex], table.rows[bIndex], direction),
      // When the SO is updated, then this property will trigger a re-sort of the table
      defaultSortDirection: columnConfig.sortingColumnId === column.id && columnConfig.sortingDirection !== 'none' ? columnConfig.sortingDirection : undefined
    };
  });
};
exports.buildSchemaDetectors = buildSchemaDetectors;