"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfigureLensHelpersAsync = exports.ConfigureInLensPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_CONFIGURE_IN_LENS = 'ACTION_CONFIGURE_IN_LENS';
const getConfigureLensHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
exports.getConfigureLensHelpersAsync = getConfigureLensHelpersAsync;
class ConfigureInLensPanelAction {
  constructor(startDependencies, overlays, theme) {
    (0, _defineProperty2.default)(this, "type", ACTION_CONFIGURE_IN_LENS);
    (0, _defineProperty2.default)(this, "id", ACTION_CONFIGURE_IN_LENS);
    (0, _defineProperty2.default)(this, "order", 50);
    this.startDependencies = startDependencies;
    this.overlays = overlays;
    this.theme = theme;
  }
  getDisplayName({
    embeddable
  }) {
    const language = (0, _utils.isLensEmbeddable)(embeddable) ? embeddable.getTextBasedLanguage() : undefined;
    return _i18n.i18n.translate('xpack.lens.app.editVisualizationLabel', {
      defaultMessage: 'Edit {lang} visualization',
      values: {
        lang: language
      }
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    embeddable
  }) {
    const {
      isEditActionCompatible
    } = await getConfigureLensHelpersAsync();
    return isEditActionCompatible(embeddable);
  }
  async execute({
    embeddable
  }) {
    const {
      executeEditAction
    } = await getConfigureLensHelpersAsync();
    return executeEditAction({
      embeddable,
      startDependencies: this.startDependencies,
      overlays: this.overlays,
      theme: this.theme
    });
  }
}
exports.ConfigureInLensPanelAction = ConfigureInLensPanelAction;