"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentalBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLabel = _i18n.i18n.translate('xpack.lens.experimentalLabel', {
  defaultMessage: 'Technical preview'
});
const ExperimentalBadge = ({
  label = defaultLabel,
  color
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    css: (0, _react2.css)`
          vertical-align: middle;
        `,
    iconType: "beaker",
    label: label,
    size: "s",
    color: color
  }));
};
exports.ExperimentalBadge = ExperimentalBadge;