"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AUTO_APPLY_DISABLED_STORAGE_KEY = void 0;
exports.VisualizationToolbar = VisualizationToolbar;
exports.WorkspacePanelWrapper = WorkspacePanelWrapper;
require("./workspace_panel_wrapper.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _utils = require("../../../utils");
var _message_list = require("./message_list");
var _state_management = require("../../../state_management");
var _title = require("./title");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTO_APPLY_DISABLED_STORAGE_KEY = exports.AUTO_APPLY_DISABLED_STORAGE_KEY = 'autoApplyDisabled';
const unitToCSSUnit = {
  pixels: 'px',
  percentage: '%'
};
const getAspectRatioStyles = ({
  x,
  y
}) => {
  return {
    aspectRatio: `${x}/${y}`,
    ...(y > x ? {
      height: '100%',
      width: 'auto'
    } : {
      height: 'auto',
      width: '100%'
    })
  };
};
function VisualizationToolbar(props) {
  var _props$activeVisualiz;
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualizationState);
  const {
    activeVisualization,
    isFixedPosition
  } = props;
  const setVisualizationState = (0, _react.useCallback)(newState => {
    if (!activeVisualization) {
      return;
    }
    dispatchLens((0, _state_management.updateVisualizationState)({
      visualizationId: activeVisualization.id,
      newState
    }));
  }, [dispatchLens, activeVisualization]);
  const ToolbarComponent = (_props$activeVisualiz = props.activeVisualization) === null || _props$activeVisualiz === void 0 ? void 0 : _props$activeVisualiz.ToolbarComponent;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ToolbarComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: (0, _classnames.default)({
      'lnsVisualizationToolbar--fixed': isFixedPosition
    })
  }, ToolbarComponent({
    frame: props.framePublicAPI,
    state: visualization.state,
    setState: setVisualizationState
  })));
}
function WorkspacePanelWrapper({
  children,
  framePublicAPI,
  visualizationId,
  visualizationMap,
  datasourceMap,
  isFullscreen,
  getUserMessages,
  displayOptions
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const activeVisualization = visualizationId ? visualizationMap[visualizationId] : null;
  const userMessages = getUserMessages('toolbar');
  const aspectRatio = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.aspectRatio;
  const maxDimensions = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.maxDimensions;
  const minDimensions = displayOptions === null || displayOptions === void 0 ? void 0 : displayOptions.minDimensions;
  let visDimensionsCSS = {};
  if (aspectRatio) {
    visDimensionsCSS = getAspectRatioStyles(aspectRatio !== null && aspectRatio !== void 0 ? aspectRatio : maxDimensions);
  }
  if (maxDimensions) {
    visDimensionsCSS.maxWidth = maxDimensions.x ? `${maxDimensions.x.value}${unitToCSSUnit[maxDimensions.x.unit]}` : '';
    visDimensionsCSS.maxHeight = maxDimensions.y ? `${maxDimensions.y.value}${unitToCSSUnit[maxDimensions.y.unit]}` : '';
  }
  if (minDimensions) {
    visDimensionsCSS.minWidth = minDimensions.x ? `${minDimensions.x.value}${unitToCSSUnit[minDimensions.x.unit]}` : '';
    visDimensionsCSS.minHeight = minDimensions.y ? `${minDimensions.y.value}${unitToCSSUnit[minDimensions.y.unit]}` : '';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    direction: "column",
    offset: 0,
    minHeight: 0,
    restrictWidth: false,
    mainProps: {
      component: 'div'
    }
  }, !(isFullscreen && (autoApplyEnabled || userMessages !== null && userMessages !== void 0 && userMessages.length)) && /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "none",
    color: "transparent",
    className: "hide-for-sharing"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s",
    direction: "row",
    className: (0, _classnames.default)('lnsWorkspacePanelWrapper__toolbar', {
      'lnsWorkspacePanelWrapper__toolbar--fullscreen': isFullscreen
    }),
    responsive: false
  }, !isFullscreen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(VisualizationToolbar, {
    activeVisualization: activeVisualization,
    framePublicAPI: framePublicAPI
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, userMessages !== null && userMessages !== void 0 && userMessages.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_message_list.MessageList, {
    messages: userMessages
  })) : null, !autoApplyEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: autoApplyEnabled || changesApplied,
    fill: true,
    className: 'lnsWorkspacePanelWrapper__applyButton ' + _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    iconType: "checkInCircleFilled",
    onClick: () => dispatchLens((0, _state_management.applyChanges)()),
    size: "m",
    "data-test-subj": "lnsApplyChanges__toolbar",
    minWidth: "auto"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.editorFrame.applyChangesLabel",
    defaultMessage: "Apply changes"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: true,
    paddingSize: "none",
    contentProps: {
      className: 'lnsWorkspacePanelWrapper__content'
    },
    className: (0, _classnames.default)('lnsWorkspacePanelWrapper stretch-for-sharing', {
      'lnsWorkspacePanelWrapper--fullscreen': isFullscreen
    }),
    css: {
      height: '100%'
    },
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: "center",
    direction: "column",
    css: (0, _react2.css)`
            height: 100%;
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "lnsWorkspacePanelWrapper__innerContent",
    grow: false,
    css: {
      flexGrow: 0,
      height: '100%',
      width: '100%',
      ...visDimensionsCSS
    }
  }, /*#__PURE__*/_react.default.createElement(_title.WorkspaceTitle, null), children))));
}