"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.datatableFn = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _transpose_helpers = require("./transpose_helpers");
var _summary = require("./summary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const datatableFn = getFormatFactory => async (table, args, context) => {
  var _context$inspectorAda, _ref;
  if (context !== null && context !== void 0 && (_context$inspectorAda = context.inspectorAdapters) !== null && _context$inspectorAda !== void 0 && _context$inspectorAda.tables) {
    context.inspectorAdapters.tables.reset();
    context.inspectorAdapters.tables.allowCsvExport = true;
    const logTable = (0, _utils.prepareLogTable)(table, [[args.columns.map(column => column.columnId), _i18n.i18n.translate('xpack.lens.datatable.column.help', {
      defaultMessage: 'Datatable column'
    })]], true);
    context.inspectorAdapters.tables.logDatatable('default', logTable);
  }
  let untransposedData;
  const formatters = {};
  const formatFactory = await getFormatFactory(context);
  table.columns.forEach(column => {
    var _column$meta;
    formatters[column.id] = formatFactory((_column$meta = column.meta) === null || _column$meta === void 0 ? void 0 : _column$meta.params);
  });
  const hasTransposedColumns = args.columns.some(c => c.isTransposed);
  if (hasTransposedColumns) {
    // store original shape of data separately
    untransposedData = (0, _lodash.cloneDeep)(table);
    // transposes table and args inplace
    (0, _transpose_helpers.transposeTable)(args, table, formatters);
  }
  const columnsWithSummary = args.columns.filter(c => c.summaryRow);
  for (const column of columnsWithSummary) {
    column.summaryRowValue = (0, _summary.computeSummaryRowForColumn)(column, table, formatters, formatFactory({
      id: 'number'
    }));
  }
  return {
    type: 'render',
    as: 'lens_datatable_renderer',
    value: {
      data: table,
      untransposedData,
      args: {
        ...args,
        title: (_ref = context.variables.embeddableTitle) !== null && _ref !== void 0 ? _ref : args.title
      }
    }
  };
};
exports.datatableFn = datatableFn;