"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLastUpdated = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLastUpdated = globalFilter => {
  const {
    timelines: timelinesUi
  } = (0, _public.useKibana)().services;

  // Only reset updated at on refresh or after globalFilter gets updated
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const updatedAt = (0, _react.useMemo)(() => Date.now(), [globalFilter]);
  return timelinesUi.getLastUpdated({
    updatedAt: updatedAt || Date.now()
  });
};
exports.useLastUpdated = useLastUpdated;