"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUrlTracker = createUrlTracker;
var _history = require("history");
var _kbn_url_storage = require("./kbn_url_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Replicates what src/legacy/ui/public/chrome/api/nav.ts did
 * Persists the url in sessionStorage so it could be restored if navigated back to the app
 */
function createUrlTracker(key, storage = sessionStorage) {
  return {
    startTrackingUrl(history = (0, _history.createBrowserHistory)()) {
      const track = location => {
        const url = (0, _kbn_url_storage.getRelativeToHistoryPath)(history.createHref(location), history);
        storage.setItem(key, url);
      };
      track(history.location);
      return history.listen(track);
    },
    getTrackedUrl() {
      return storage.getItem(key);
    },
    trackUrl(url) {
      storage.setItem(key, url);
    }
  };
}