"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIntegrityHash = getIntegrityHash;
exports.getIntegrityHashes = getIntegrityHashes;
var _crypto = require("crypto");
var fs = _interopRequireWildcard(require("fs"));
var _lodash = require("lodash");
var stream = _interopRequireWildcard(require("stream"));
var util = _interopRequireWildcard(require("util"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const pipeline = util.promisify(stream.pipeline);
async function getIntegrityHashes(filepaths) {
  const hashes = await Promise.all(filepaths.map(getIntegrityHash));
  return (0, _lodash.zipObject)(filepaths, hashes);
}
async function getIntegrityHash(filepath) {
  try {
    const output = (0, _crypto.createHash)('sha256');
    await pipeline(fs.createReadStream(filepath), output);
    const data = output.read();
    if (data instanceof Buffer) {
      return data.toString('hex');
    }
    return data;
  } catch (err) {
    return null;
  }
}