"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withKibana = exports.useKibana = exports.createKibanaReactContext = exports.context = exports.KibanaContextProvider = void 0;
var React = _interopRequireWildcard(require("react"));
var _overlays = require("../overlays");
var _notifications = require("../notifications");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const {
  useMemo,
  useContext,
  createElement,
  createContext
} = React;
const defaultContextValue = {
  services: {},
  overlays: (0, _overlays.createReactOverlays)({}),
  notifications: (0, _notifications.createNotifications)({})
};
const context = exports.context = createContext(defaultContextValue);
const useKibana = () => useContext(context);
exports.useKibana = useKibana;
const withKibana = type => {
  const EnhancedType = props => {
    const kibana = useKibana();
    return /*#__PURE__*/React.createElement(type, {
      ...props,
      kibana
    });
  };
  return EnhancedType;
};
exports.withKibana = withKibana;
const createKibanaReactContext = services => {
  const value = {
    services,
    overlays: (0, _overlays.createReactOverlays)(services),
    notifications: (0, _notifications.createNotifications)(services)
  };
  const Provider = ({
    services: newServices = {},
    children
  }) => {
    const oldValue = useKibana();
    const {
      value: newValue
    } = useMemo(() => createKibanaReactContext({
      ...services,
      ...oldValue.services,
      ...newServices
    }), [services, oldValue, newServices]);
    const newProvider = createElement(context.Provider, {
      value: newValue,
      children
    });
    return newProvider;
  };
  return {
    value,
    Provider,
    Consumer: context.Consumer
  };
};
exports.createKibanaReactContext = createKibanaReactContext;
const {
  Provider: KibanaContextProvider
} = createKibanaReactContext({});
exports.KibanaContextProvider = KibanaContextProvider;