"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toJsonSchema = void 0;
var _lodash = require("lodash");
var _parseable_types = require("../parseable_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const toJsonSchema = type => {
  if ((0, _parseable_types.isParsableType)(type)) {
    switch (type._tag) {
      case 'ArrayType':
        return {
          type: 'array',
          items: toJsonSchema(type.type)
        };
      case 'BooleanType':
        return {
          type: 'boolean'
        };
      case 'DictionaryType':
        return {
          type: 'object',
          additionalProperties: toJsonSchema(type.codomain)
        };
      case 'InterfaceType':
        return {
          type: 'object',
          properties: (0, _lodash.mapValues)(type.props, toJsonSchema),
          required: Object.keys(type.props)
        };
      case 'PartialType':
        return {
          type: 'object',
          properties: (0, _lodash.mapValues)(type.props, toJsonSchema)
        };
      case 'UnionType':
        return {
          anyOf: type.types.map(toJsonSchema)
        };
      case 'IntersectionType':
        return {
          allOf: type.types.map(toJsonSchema)
        };
      case 'NumberType':
        return {
          type: 'number'
        };
      case 'StringType':
        return {
          type: 'string'
        };
    }
  }
  return {
    type: 'object'
  };
};
exports.toJsonSchema = toJsonSchema;