"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInputControlVisRenderer = void 0;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const inputControlVisRegistry = new Map();
const getInputControlVisRenderer = deps => ({
  name: 'input_control_vis',
  reuseDomNode: true,
  render: async (domNode, {
    visConfig
  }, handlers) => {
    let registeredController = inputControlVisRegistry.get(domNode);
    if (!registeredController) {
      const {
        createInputControlVisController
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./vis_controller')));
      registeredController = createInputControlVisController(deps, handlers, domNode);
      inputControlVisRegistry.set(domNode, registeredController);
      handlers.onDestroy(() => {
        var _registeredController;
        (_registeredController = registeredController) === null || _registeredController === void 0 ? void 0 : _registeredController.destroy();
        inputControlVisRegistry.delete(domNode);
      });
    }
    await registeredController.render(visConfig);
    handlers.done();
  }
});
exports.getInputControlVisRenderer = getInputControlVisRenderer;