"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setControl = exports.removeControl = exports.newControl = exports.moveControl = exports.getTitle = exports.getDefaultOptions = exports.addControl = exports.CONTROL_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONTROL_TYPES = exports.CONTROL_TYPES = {
  LIST: 'list',
  RANGE: 'range'
};
const setControl = (controls, controlIndex, control) => [...controls.slice(0, controlIndex), control, ...controls.slice(controlIndex + 1)];
exports.setControl = setControl;
const addControl = (controls, control) => [...controls, control];
exports.addControl = addControl;
const moveControl = (controls, controlIndex, direction) => {
  let newIndex;
  if (direction >= 0) {
    newIndex = controlIndex + 1;
  } else {
    newIndex = controlIndex - 1;
  }
  if (newIndex < 0) {
    // Move first item to last
    return [...controls.slice(1), controls[0]];
  } else if (newIndex >= controls.length) {
    const lastItemIndex = controls.length - 1;
    // Move last item to first
    return [controls[lastItemIndex], ...controls.slice(0, lastItemIndex)];
  } else {
    const swapped = controls.slice();
    const temp = swapped[newIndex];
    swapped[newIndex] = swapped[controlIndex];
    swapped[controlIndex] = temp;
    return swapped;
  }
};
exports.moveControl = moveControl;
const removeControl = (controls, controlIndex) => [...controls.slice(0, controlIndex), ...controls.slice(controlIndex + 1)];
exports.removeControl = removeControl;
const getDefaultOptions = type => {
  const defaultOptions = {};
  switch (type) {
    case CONTROL_TYPES.RANGE:
      defaultOptions.decimalPlaces = 0;
      defaultOptions.step = 1;
      break;
    case CONTROL_TYPES.LIST:
      defaultOptions.type = 'terms';
      defaultOptions.multiselect = true;
      defaultOptions.dynamicOptions = true;
      defaultOptions.size = 5;
      defaultOptions.order = 'desc';
      break;
  }
  return defaultOptions;
};
exports.getDefaultOptions = getDefaultOptions;
const newControl = type => ({
  id: new Date().getTime().toString(),
  indexPattern: '',
  fieldName: '',
  parent: '',
  label: '',
  type,
  options: getDefaultOptions(type)
});
exports.newControl = newControl;
const getTitle = (controlParams, controlIndex) => {
  let title = `${controlParams.type}: ${controlIndex}`;
  if (controlParams.label) {
    title = `${controlParams.label}`;
  } else if (controlParams.fieldName) {
    title = `${controlParams.fieldName}`;
  }
  return title;
};
exports.getTitle = getTitle;