"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Instructions = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Instructions = () => {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "createFromCsvInstructions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.instructions",
    defaultMessage: "Use a CSV file to define how to map your custom data source to the Elastic Common Schema (ECS). For each {source} , you can specify a {destination} and format adjustments. Refer to the \xA0{templateLink} for the supported headers.",
    values: {
      templateLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://ela.st/sample-pipeline-mapping",
        target: "_blank"
      }, "sample mappings"),
      source: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "source_field"),
      destination: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "destination_field")
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.instructions.continued",
    defaultMessage: "Add processors to the resulting starter pipeline to perform additional data transformations."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))));
};
exports.Instructions = Instructions;