"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initCreateMetricsExplorerViewRoute = void 0;
var _boom = require("@hapi/boom");
var _runtime_types = require("../../../common/runtime_types");
var _latest = require("../../../common/http_api/latest");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NON_STARTED_SERVICE_ERROR = {
  statusCode: 500,
  body: {
    message: `Handler for "POST ${_latest.METRICS_EXPLORER_VIEW_URL}" was registered but MetricsViewService has not started.`
  }
};
const initCreateMetricsExplorerViewRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerRoute({
    method: 'post',
    path: _latest.METRICS_EXPLORER_VIEW_URL,
    validate: {
      body: (0, _runtime_types.createValidationFunction)(_latest.createMetricsExplorerViewRequestPayloadRT),
      query: (0, _runtime_types.createValidationFunction)(_latest.metricsExplorerViewRequestQueryRT)
    }
  }, async (_requestContext, request, response) => {
    const {
      body,
      query
    } = request;
    const [,, {
      metricsExplorerViews
    }] = await getStartServices();
    if (metricsExplorerViews === undefined) {
      return response.customError(NON_STARTED_SERVICE_ERROR);
    }
    const metricsExplorerViewsClient = metricsExplorerViews.getScopedClient(request);
    try {
      const metricsExplorerView = await metricsExplorerViewsClient.update(null, body.attributes, query);
      return response.custom({
        statusCode: 201,
        body: _latest.metricsExplorerViewResponsePayloadRT.encode({
          data: metricsExplorerView
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      if ((0, _boom.isBoom)(error)) {
        return response.customError({
          statusCode: error.output.statusCode,
          body: {
            message: error.output.payload.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  });
};
exports.initCreateMetricsExplorerViewRoute = initCreateMetricsExplorerViewRoute;