"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredHosts = void 0;
var _constants = require("../constants");
var _utils = require("../utils");
var _query = require("../helpers/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredHosts = async ({
  infraMetricsClient,
  params
}) => {
  var _params$limit;
  (0, _utils.assertQueryStructure)(params.query);
  return infraMetricsClient.search({
    allow_no_indices: true,
    ignore_unavailable: true,
    body: {
      size: 0,
      track_total_hits: false,
      query: {
        bool: {
          ...params.query.bool,
          filter: (0, _query.createFilters)({
            params,
            extraFilter: params.query
          })
        }
      },
      aggs: {
        nodes: {
          terms: {
            size: (_params$limit = params.limit) !== null && _params$limit !== void 0 ? _params$limit : _constants.MAX_SIZE,
            field: _constants.BUCKET_KEY,
            order: {
              _key: 'asc'
            }
          }
        }
      }
    }
  });
};
exports.getFilteredHosts = getFilteredHosts;