"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveFieldsFromFilter = exports.buildCombinedHostsFilter = exports.buildAssetIdFilter = void 0;
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/metrics-data-access-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildCombinedHostsFilter = ({
  field,
  values,
  dataView
}) => {
  const indexField = dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(field);
  if (!dataView || !indexField) {
    return {
      query: {
        terms: {
          [field]: values
        }
      },
      meta: {}
    };
  }
  const filtersFromValues = values.map(value => (0, _esQuery.buildPhraseFilter)(indexField, value, dataView));
  return (0, _esQuery.buildCombinedFilter)(_esQuery.BooleanRelation.OR, filtersFromValues, dataView);
};
exports.buildCombinedHostsFilter = buildCombinedHostsFilter;
const retrieveFieldsFromFilter = (filters, fields = []) => {
  for (const filter of filters) {
    if ((0, _esQuery.isCombinedFilter)(filter)) {
      retrieveFieldsFromFilter(filter.meta.params, fields);
    }
    if (filter.meta.key) {
      fields.push(filter.meta.key);
    }
  }
  return fields;
};
exports.retrieveFieldsFromFilter = retrieveFieldsFromFilter;
const buildAssetIdFilter = (assetId, assetType, dataView) => {
  const assetIdField = dataView.getFieldByName((0, _common.findInventoryFields)(assetType).id);
  return assetIdField ? [(0, _esQuery.buildPhraseFilter)(assetIdField, assetId, dataView)] : [];
};
exports.buildAssetIdFilter = buildAssetIdFilter;