"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCancellableEffect = exports.createCancellationSignal = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCancellationSignal = () => {
  const cancellationSignal = {
    isCancelled: false,
    cancel: () => {
      cancellationSignal.isCancelled = true;
    }
  };
  return cancellationSignal;
};
exports.createCancellationSignal = createCancellationSignal;
const useCancellableEffect = (effect, deps) => {
  (0, _react.useEffect)(() => {
    const cancellationSignal = createCancellationSignal();
    effect(() => cancellationSignal.isCancelled);
    return cancellationSignal.cancel;

    // the dependencies are managed externally
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, deps);
};
exports.useCancellableEffect = useCancellableEffect;