"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredMetrics = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilteredMetrics = (requiredMetrics, metadata) => {
  const metricMetadata = metadata.filter(data => data && data.source === 'metrics').map(data => data && data.name);
  return requiredMetrics.filter(metric => {
    const metricModelCreator = _common.metrics.tsvb[metric];

    // We just need to get a dummy version of the model so we can filter
    // using the `requires` attribute.
    const metricModel = metricModelCreator(_constants.TIMESTAMP_FIELD, 'test', '>=1m');
    return metricMetadata.some(m => m && metricModel.requires.includes(m));
  });
};
exports.getFilteredMetrics = getFilteredMetrics;