"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _empty_states = require("../../../components/empty_states");
var _source_error_page = require("../../../components/source_error_page");
var _source_loading_page = require("../../../components/source_loading_page");
var _metrics_source = require("../../../containers/metrics_source");
var _asset_details = require("../../../components/asset_details");
var _page_template = require("../page_template");
var _asset_details_tabs = require("../../../common/asset_details_config/asset_details_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetDetailPage = () => {
  var _source$status;
  const {
    isLoading,
    loadSourceFailureMessage,
    loadSource,
    source
  } = (0, _metrics_source.useSourceContext)();
  const {
    params: {
      type: nodeType,
      node: nodeId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    metricIndicesExist,
    remoteClustersExist
  } = (_source$status = source === null || source === void 0 ? void 0 : source.status) !== null && _source$status !== void 0 ? _source$status : {};
  if (isLoading || !source) return /*#__PURE__*/_react.default.createElement(_source_loading_page.SourceLoadingPage, null);
  if (!remoteClustersExist) {
    return /*#__PURE__*/_react.default.createElement(_empty_states.NoRemoteCluster, null);
  }
  if (!metricIndicesExist) {
    return /*#__PURE__*/_react.default.createElement(_page_template.MetricsPageTemplate, {
      hasData: metricIndicesExist,
      "data-test-subj": "noMetricsIndicesPrompt"
    });
  }
  if (loadSourceFailureMessage) return /*#__PURE__*/_react.default.createElement(_source_error_page.SourceErrorPage, {
    errorMessage: loadSourceFailureMessage || '',
    retry: loadSource
  });
  return /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    assetId: nodeId,
    assetType: nodeType,
    tabs: _asset_details_tabs.commonFlyoutTabs,
    renderMode: {
      mode: 'page'
    },
    metricAlias: source.configuration.metricAlias
  });
};
exports.AssetDetailPage = AssetDetailPage;