"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDetailsFlyout = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../components/asset_details/types");
var _asset_details = require("../../../../../components/asset_details");
var _metrics_source = require("../../../../../containers/metrics_source");
var _asset_details_tabs = require("../../../../../common/asset_details_config/asset_details_tabs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flyoutTabs = [..._asset_details_tabs.commonFlyoutTabs, {
  id: _types.ContentTabIds.LINK_TO_APM,
  name: _i18n.i18n.translate('xpack.infra.assetDetails.tabs.linkToApm', {
    defaultMessage: 'APM'
  })
}];
const ONE_HOUR = 60 * 60 * 1000;
const AssetDetailsFlyout = ({
  assetName,
  assetType,
  closeFlyout,
  currentTime,
  options,
  refreshInterval,
  isAutoReloading = false
}) => {
  const {
    source
  } = (0, _metrics_source.useSourceContext)();
  const dateRange = (0, _react.useMemo)(() => {
    // forces relative dates when auto-refresh is active
    return isAutoReloading ? {
      from: 'now-1h',
      to: 'now'
    } : {
      from: new Date(currentTime - ONE_HOUR).toISOString(),
      to: new Date(currentTime).toISOString()
    };
  }, [currentTime, isAutoReloading]);
  return source ? /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    assetId: assetName,
    assetName: assetName,
    assetType: assetType,
    overrides: {
      metadata: {
        showActionsColumn: false
      },
      alertRule: {
        options
      }
    },
    tabs: flyoutTabs,
    links: ['nodeDetails'],
    renderMode: {
      mode: 'flyout',
      closeFlyout
    },
    metricAlias: source.configuration.metricAlias,
    dateRange: dateRange,
    autoRefresh: {
      isPaused: !isAutoReloading,
      interval: refreshInterval
    }
  }) : null;
};
exports.AssetDetailsFlyout = AssetDetailsFlyout;