"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableView = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _nodes_to_wafflemap = require("../lib/nodes_to_wafflemap");
var _field_to_display_name = require("../lib/field_to_display_name");
var _node_context_menu = require("./waffle/node_context_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialSorting = {
  sort: {
    field: 'value',
    direction: 'desc'
  }
};
const getGroupPaths = path => {
  switch (path.length) {
    case 3:
      return path.slice(0, 2);
    case 2:
      return path.slice(0, 1);
    default:
      return [];
  }
};
const TableView = props => {
  const {
    nodes,
    options,
    formatter,
    currentTime,
    nodeType
  } = props;
  const [openPopoverId, setOpenPopoverId] = (0, _react.useState)(null);
  const closePopover = () => setOpenPopoverId(null);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.infra.tableView.columnName.name', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true,
    textOnly: true,
    render: (value, item) => {
      const tooltipText = item.node.id === value ? `${value}` : `${value} (${item.node.id})`;
      // For the table we need to create a UniqueID that takes into to account the groupings
      // as well as the node name. There is the possibility that a node can be present in two
      // different groups and be on the screen at the same time.
      const uniqueID = [...item.node.path.map(p => p.value), item.node.name].join(':');
      const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltipText
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "infraColumnsButton",
        onClick: () => setOpenPopoverId(uniqueID)
      }, value));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: button,
        isOpen: openPopoverId === uniqueID,
        closePopover: closePopover,
        anchorPosition: "rightCenter"
      }, /*#__PURE__*/_react.default.createElement(_node_context_menu.NodeContextMenu, {
        node: item.node,
        nodeType: nodeType,
        currentTime: currentTime,
        options: options
      }));
    }
  }, ...options.groupBy.map((grouping, index) => ({
    field: `group_${index}`,
    name: (0, _field_to_display_name.fieldToName)(grouping && grouping.field || ''),
    sortable: true,
    truncateText: true,
    textOnly: true,
    render: value => {
      const handleClick = () => props.onFilter(`${grouping.field}:"${value}"`);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: "Set Filter"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "infraColumnsButton",
        onClick: handleClick
      }, value));
    }
  })), {
    field: 'value',
    name: _i18n.i18n.translate('xpack.infra.tableView.columnName.last1m', {
      defaultMessage: 'Last 1m'
    }),
    sortable: true,
    truncateText: true,
    dataType: 'number',
    render: value => /*#__PURE__*/_react.default.createElement("span", null, formatter(value))
  }, {
    field: 'avg',
    name: _i18n.i18n.translate('xpack.infra.tableView.columnName.avg', {
      defaultMessage: 'Avg'
    }),
    sortable: true,
    truncateText: true,
    dataType: 'number',
    render: value => /*#__PURE__*/_react.default.createElement("span", null, formatter(value))
  }, {
    field: 'max',
    name: _i18n.i18n.translate('xpack.infra.tableView.columnName.max', {
      defaultMessage: 'Max'
    }),
    sortable: true,
    truncateText: true,
    dataType: 'number',
    render: value => /*#__PURE__*/_react.default.createElement("span", null, formatter(value))
  }];
  const items = (0, _react.useMemo)(() => nodes.map(node => {
    const name = (0, _lodash.last)(node.path);
    const metric = (0, _lodash.first)(node.metrics);
    return {
      name: name && name.label || 'unknown',
      ...getGroupPaths(node.path).reduce((acc, path, index) => ({
        ...acc,
        [`group_${index}`]: path.label
      }), {}),
      value: metric && metric.value || 0,
      avg: metric && metric.avg || 0,
      max: metric && metric.max || 0,
      node: (0, _nodes_to_wafflemap.createWaffleMapNode)(node)
    };
  }), [nodes]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    pagination: true,
    sorting: initialSorting,
    items: items,
    columns: columns
  });
};
exports.TableView = TableView;