"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Chart = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _use_data_view = require("../../../../../../hooks/use_data_view");
var _constants = require("../../../../../../common/visualizations/constants");
var _lens = require("../../../../../../components/lens");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _build = require("../../../../../../utils/filters/build");
var _use_hosts_table = require("../../../hooks/use_hosts_table");
var _use_after_loaded_state = require("../../../hooks/use_after_loaded_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Chart = ({
  id,
  ...chartProps
}) => {
  var _chartProps$dataset;
  const {
    searchCriteria
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    loading,
    searchSessionId
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    currentPage
  } = (0, _use_hosts_table.useHostsTableContext)();
  const {
    dataView
  } = (0, _use_data_view.useDataView)({
    index: (_chartProps$dataset = chartProps.dataset) === null || _chartProps$dataset === void 0 ? void 0 : _chartProps$dataset.index
  });
  const shouldUseSearchCriteria = currentPage.length === 0;

  // prevents searchCriteria state from reloading the chart
  // we want it to reload only once the table has finished loading.
  // attributes passed to useAfterLoadedState don't need to be memoized
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    dateRange: searchCriteria.dateRange,
    query: shouldUseSearchCriteria ? searchCriteria.query : undefined,
    searchSessionId
  });
  const filters = (0, _react.useMemo)(() => {
    var _searchCriteria$panel;
    return shouldUseSearchCriteria ? [...searchCriteria.filters, ...((_searchCriteria$panel = searchCriteria.panelFilters) !== null && _searchCriteria$panel !== void 0 ? _searchCriteria$panel : [])] : [(0, _build.buildCombinedHostsFilter)({
      field: 'host.name',
      values: currentPage.map(p => p.name),
      dataView
    })];
  }, [shouldUseSearchCriteria, searchCriteria.filters, searchCriteria.panelFilters, currentPage, dataView]);
  return /*#__PURE__*/_react.default.createElement(_lens.LensChart, (0, _extends2.default)({}, chartProps, {
    id: `hostsView-metricChart-${id}`,
    borderRadius: "m",
    dateRange: afterLoadedState.dateRange,
    height: _constants.METRIC_CHART_HEIGHT,
    loading: loading,
    filters: filters,
    query: afterLoadedState.query,
    searchSessionId: afterLoadedState.searchSessionId
  }));
};
exports.Chart = Chart;