"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/logs-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _loading = require("../../../../../../components/loading");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_logs_search_url_state = require("../../../hooks/use_logs_search_url_state");
var _logs_link_to_stream = require("./logs_link_to_stream");
var _logs_search_bar = require("./logs_search_bar");
var _build = require("../../../../../../utils/filters/build");
var _use_log_view_reference = require("../../../../../../hooks/use_log_view_reference");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsTabContent = () => {
  const [filterQuery] = (0, _use_logs_search_url_state.useLogsSearchUrlState)();
  const {
    getDateRangeAsTimestamp
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    from,
    to
  } = (0, _react.useMemo)(() => getDateRangeAsTimestamp(), [getDateRangeAsTimestamp]);
  const {
    hostNodes,
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const hostsFilterQuery = (0, _react.useMemo)(() => (0, _build.buildCombinedHostsFilter)({
    field: 'host.name',
    values: hostNodes.map(p => p.name)
  }), [hostNodes]);
  const {
    logViewReference: logView,
    loading: logViewLoading
  } = (0, _use_log_view_reference.useLogViewReference)({
    id: 'hosts-logs-view',
    name: _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.logs.LogsByHostWidgetName', {
      defaultMessage: 'Logs by host'
    }),
    extraFields: ['host.name']
  });
  const logsLinkToStreamQuery = (0, _react.useMemo)(() => {
    const hostsFilterQueryParam = createHostsFilterQueryParam(hostNodes.map(p => p.name));
    if (filterQuery.query && hostsFilterQueryParam) {
      return `${filterQuery.query} and ${hostsFilterQueryParam}`;
    }
    return filterQuery.query || hostsFilterQueryParam;
  }, [filterQuery.query, hostNodes]);
  if (loading || logViewLoading || !logView) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        height: 300
      },
      direction: "column",
      alignItems: "stretch"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
      width: "100%",
      height: "100%",
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.hostsViewPage.tabs.logs.loadingEntriesLabel",
        defaultMessage: "Loading entries"
      })
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "hostsView-logs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_logs_search_bar.LogsSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_logs_link_to_stream.LogsLinkToStream, {
    startTime: from,
    endTime: to,
    query: logsLinkToStreamQuery,
    logView: logView
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.LogStream, {
    height: 500,
    logView: logView,
    startTimestamp: from,
    endTimestamp: to,
    filters: [hostsFilterQuery],
    query: filterQuery,
    showFlyoutAction: true
  })));
};
exports.LogsTabContent = LogsTabContent;
const createHostsFilterQueryParam = hostNodes => {
  if (!hostNodes.length) {
    return '';
  }
  const joinedHosts = hostNodes.join(' or ');
  const hostsQueryParam = `host.name:(${joinedHosts})`;
  return hostsQueryParam;
};