"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsLinkToStream = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/logs-shared-plugin/common");
var _use_kibana = require("../../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsLinkToStream = ({
  startTime,
  endTime,
  query,
  logView
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    share
  } = services;
  const {
    logsLocator
  } = (0, _common.getLogsLocatorsFromUrlService)(share.url);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: logsLocator.getRedirectUrl({
      time: endTime,
      timeRange: {
        startTime,
        endTime
      },
      filter: query,
      logView
    }),
    "data-test-subj": "hostsView-logs-link-to-stream-button",
    iconType: "popout",
    flush: "both"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.hostsViewPage.tabs.logs.openInLogsUiLinkText",
    defaultMessage: "Open in Logs"
  }));
};
exports.LogsLinkToStream = LogsLinkToStream;