"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsPageContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _log_threshold = require("../../alerting/log_threshold");
var _help_center_content = require("../../components/help_center_content");
var _use_kibana = require("../../hooks/use_kibana");
var _use_readonly_badge = require("../../hooks/use_readonly_badge");
var _header_action_menu_provider = require("../../utils/header_action_menu_provider");
var _redirect_with_query_params = require("../../utils/redirect_with_query_params");
var _log_entry_categories = require("./log_entry_categories");
var _log_entry_rate = require("./log_entry_rate");
var _settings = require("./settings");
var _stream = require("./stream");
var _dev_mode = require("../../utils/dev_mode");
var _xstate_helpers = require("../../observability_logs/xstate_helpers");
var _ = require("../404");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsPageContent = () => {
  var _useKibana$services$a, _uiCapabilities$logs;
  const uiCapabilities = (_useKibana$services$a = (0, _public.useKibana)().services.application) === null || _useKibana$services$a === void 0 ? void 0 : _useKibana$services$a.capabilities;
  const {
    setHeaderActionMenu,
    theme$
  } = (0, _react.useContext)(_header_action_menu_provider.HeaderActionMenuContext);
  const {
    application: {
      getUrlForApp
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const enableDeveloperRoutes = (0, _dev_mode.isDevMode)();
  (0, _use_readonly_badge.useReadOnlyBadge)(!(uiCapabilities !== null && uiCapabilities !== void 0 && (_uiCapabilities$logs = uiCapabilities.logs) !== null && _uiCapabilities$logs !== void 0 && _uiCapabilities$logs.save));

  // !! Need to be kept in sync with the deepLinks in x-pack/plugins/observability_solution/infra/public/plugin.ts
  const streamTab = {
    app: 'logs',
    title: streamTabTitle,
    pathname: '/stream'
  };
  const anomaliesTab = {
    app: 'logs',
    title: anomaliesTabTitle,
    pathname: '/anomalies'
  };
  const logCategoriesTab = {
    app: 'logs',
    title: logCategoriesTabTitle,
    pathname: '/log-categories'
  };
  const settingsTab = {
    app: 'logs',
    title: settingsTabTitle,
    pathname: '/settings'
  };
  const settingsLinkProps = (0, _public2.useLinkProps)({
    app: 'logs',
    pathname: 'settings'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_help_center_content.HelpCenterContent, {
    feedbackLink: feedbackLinkUrl,
    appName: pageTitle
  }), setHeaderActionMenu && theme$ && /*#__PURE__*/_react.default.createElement(_public2.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, (0, _extends2.default)({
    color: 'text'
  }, settingsLinkProps), settingsTabTitle), /*#__PURE__*/_react.default.createElement(_log_threshold.LazyAlertDropdownWrapper, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    href: getUrlForApp('/observabilityOnboarding'),
    color: "primary",
    iconType: "indexOpen"
  }, ADD_DATA_LABEL))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: streamTab.pathname,
    component: _stream.StreamPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: anomaliesTab.pathname,
    component: _log_entry_rate.LogEntryRatePage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: logCategoriesTab.pathname,
    component: _log_entry_categories.LogEntryCategoriesPage
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: settingsTab.pathname,
    component: _settings.LogsSettingsPage
  }), enableDeveloperRoutes && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/state-machine-playground',
    component: _xstate_helpers.StateMachinePlayground
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/analysis',
    to: anomaliesTab.pathname,
    exact: true
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/log-rate',
    to: anomaliesTab.pathname,
    exact: true
  }), /*#__PURE__*/_react.default.createElement(_redirect_with_query_params.RedirectWithQueryParams, {
    from: '/',
    to: streamTab.pathname,
    exact: true
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: () => /*#__PURE__*/_react.default.createElement(_.NotFoundPage, {
      title: _i18n.i18n.translate('xpack.infra.logs.index.logsLabel', {
        defaultMessage: 'Logs'
      })
    })
  })));
};
exports.LogsPageContent = LogsPageContent;
const pageTitle = _i18n.i18n.translate('xpack.infra.header.logsTitle', {
  defaultMessage: 'Logs'
});
const streamTabTitle = _i18n.i18n.translate('xpack.infra.logs.index.streamTabTitle', {
  defaultMessage: 'Stream'
});
const anomaliesTabTitle = _i18n.i18n.translate('xpack.infra.logs.index.anomaliesTabTitle', {
  defaultMessage: 'Anomalies'
});
const logCategoriesTabTitle = _i18n.i18n.translate('xpack.infra.logs.index.logCategoriesBetaBadgeTitle', {
  defaultMessage: 'Categories'
});
const settingsTabTitle = _i18n.i18n.translate('xpack.infra.logs.index.settingsTabTitle', {
  defaultMessage: 'Settings'
});
const feedbackLinkUrl = 'https://discuss.elastic.co/c/logs';
const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.infra.logsHeaderAddDataButtonLabel', {
  defaultMessage: 'Add data'
});