"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesTable = void 0;
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useSet = _interopRequireDefault(require("react-use/lib/useSet"));
var _log_analysis = require("../../../../../../common/log_analysis");
var _basic_table = require("../../../../../components/basic_table");
var _expanded_row = require("./expanded_row");
var _anomaly_severity_indicator = require("../../../../../components/logging/log_analysis_results/anomaly_severity_indicator");
var _category_expression = require("../../../../../components/logging/log_analysis_results/category_expression");
var _use_kibana_ui_setting = require("../../../../../utils/use_kibana_ui_setting");
var _loading_overlay_wrapper = require("../../../../../components/loading_overlay_wrapper");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const anomalyScoreColumnName = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableAnomalyScoreColumnName', {
  defaultMessage: 'Anomaly score'
});
const anomalyMessageColumnName = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableAnomalyMessageName', {
  defaultMessage: 'Anomaly'
});
const anomalyStartTimeColumnName = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableAnomalyStartTime', {
  defaultMessage: 'Start time'
});
const datasetColumnName = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableAnomalyDatasetName', {
  defaultMessage: 'Dataset'
});
const AnomaliesTable = ({
  results,
  timeRange,
  changeSortOptions,
  sortOptions,
  changePaginationOptions,
  paginationOptions,
  fetchNextPage,
  fetchPreviousPage,
  page,
  isLoading
}) => {
  const [dateFormat] = (0, _use_kibana_ui_setting.useKibanaUiSetting)('dateFormat', 'Y-MM-DD HH:mm:ss');
  const tableSortOptions = (0, _react.useMemo)(() => {
    return {
      sort: sortOptions
    };
  }, [sortOptions]);
  const tableItems = (0, _react.useMemo)(() => {
    return results.map(anomaly => {
      return {
        id: anomaly.id,
        dataset: anomaly.dataset,
        anomalyScore: anomaly.anomalyScore,
        startTime: anomaly.startTime,
        type: anomaly.type,
        typical: anomaly.typical,
        actual: anomaly.actual,
        categoryRegex: (0, _log_analysis.isCategoryAnomaly)(anomaly) ? anomaly.categoryRegex : undefined
      };
    });
  }, [results]);
  const [expandedIds, {
    add: expandId,
    remove: collapseId
  }] = (0, _useSet.default)(new Set());
  const expandedIdsRowContents = (0, _react.useMemo)(() => [...expandedIds].reduce((aggregatedRows, id) => {
    const anomaly = results.find(_anomaly => _anomaly.id === id);
    return {
      ...aggregatedRows,
      [id]: anomaly ? /*#__PURE__*/_react.default.createElement(_expanded_row.AnomaliesTableExpandedRow, {
        anomaly: anomaly,
        timeRange: timeRange
      }) : null
    };
  }, {}), [expandedIds, results, timeRange]);
  const handleTableChange = (0, _react.useCallback)(({
    sort = {}
  }) => {
    changeSortOptions(sort);
  }, [changeSortOptions]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'anomalyScore',
    name: anomalyScoreColumnName,
    sortable: true,
    truncateText: true,
    dataType: 'number',
    width: '130px',
    render: anomalyScore => /*#__PURE__*/_react.default.createElement(_anomaly_severity_indicator.AnomalySeverityIndicator, {
      anomalyScore: anomalyScore
    })
  }, {
    name: anomalyMessageColumnName,
    truncateText: true,
    render: item => /*#__PURE__*/_react.default.createElement(AnomalyMessage, {
      anomaly: item
    })
  }, {
    field: 'startTime',
    name: anomalyStartTimeColumnName,
    sortable: true,
    truncateText: true,
    width: '230px',
    render: startTime => (0, _moment.default)(startTime).format(dateFormat)
  }, {
    field: 'dataset',
    name: datasetColumnName,
    sortable: true,
    truncateText: true,
    width: '200px',
    render: dataset => (0, _log_analysis.getFriendlyNameForPartitionId)(dataset)
  }, {
    align: _eui.RIGHT_ALIGNMENT,
    width: '40px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_basic_table.RowExpansionButton, {
      isExpanded: expandedIds.has(item.id),
      item: item.id,
      onExpand: expandId,
      onCollapse: collapseId
    })
  }], [collapseId, expandId, expandedIds, dateFormat]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: tableItems,
    itemId: "id",
    itemIdToExpandedRowMap: expandedIdsRowContents,
    isExpandable: true,
    hasActions: true,
    columns: columns,
    sorting: tableSortOptions,
    onChange: handleTableChange
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(PaginationControls, {
    fetchNextPage: fetchNextPage,
    fetchPreviousPage: fetchPreviousPage,
    page: page,
    isLoading: isLoading
  })));
};
exports.AnomaliesTable = AnomaliesTable;
const AnomalyMessage = ({
  anomaly
}) => {
  const {
    type,
    actual,
    typical
  } = anomaly;
  const moreThanExpectedAnomalyMessage = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableMoreThanExpectedAnomalyMessage', {
    defaultMessage: 'more log messages in this {type, select, logRate {dataset} logCategory {category}} than expected',
    values: {
      type
    }
  });
  const fewerThanExpectedAnomalyMessage = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableFewerThanExpectedAnomalyMessage', {
    defaultMessage: 'fewer log messages in this {type, select, logRate {dataset} logCategory {category}} than expected',
    values: {
      type
    }
  });
  const isMore = actual > typical;
  const message = isMore ? moreThanExpectedAnomalyMessage : fewerThanExpectedAnomalyMessage;
  const ratio = isMore ? actual / typical : typical / actual;
  const icon = isMore ? 'sortUp' : 'sortDown';
  // Edge case scenarios where actual and typical might sit at 0.
  const useRatio = ratio !== Infinity;
  const ratioMessage = useRatio ? `${(0, _log_analysis.formatOneDecimalPlace)(ratio)}x` : '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span"
  }, `${ratioMessage} ${message}`, anomaly.categoryRegex && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ': ', /*#__PURE__*/_react.default.createElement(_category_expression.RegularExpressionRepresentation, {
    regularExpression: anomaly.categoryRegex
  }))));
};
const previousPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTablePreviousPageLabel', {
  defaultMessage: 'Previous page'
});
const nextPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableNextPageLabel', {
  defaultMessage: 'Next page'
});
const PaginationControls = ({
  fetchPreviousPage,
  fetchNextPage,
  page,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowLeft",
    isDisabled: !fetchPreviousPage || isLoading,
    onClick: fetchPreviousPage,
    "aria-label": previousPageLabel
  }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, page)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowRight",
    isDisabled: !fetchNextPage || isLoading,
    onClick: fetchNextPage,
    "aria-label": nextPageLabel
  }))));
};