"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoriesResultsUrlState = exports.stringTimeRangeRT = void 0;
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var rt = _interopRequireWildcard(require("io-ts"));
var _use_url_state = require("../../../utils/use_url_state");
var _use_kibana_timefilter_time = require("../../../hooks/use_kibana_timefilter_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const autoRefreshRT = rt.union([rt.type({
  interval: rt.number,
  isPaused: rt.boolean
}), rt.undefined]);
const stringTimeRangeRT = exports.stringTimeRangeRT = rt.type({
  startTime: rt.string,
  endTime: rt.string
});
const urlTimeRangeRT = rt.union([stringTimeRangeRT, rt.undefined]);
const TIME_RANGE_URL_STATE_KEY = 'timeRange';
const AUTOREFRESH_URL_STATE_KEY = 'autoRefresh';
const TIME_DEFAULTS = {
  from: 'now-2w',
  to: 'now'
};
const useLogEntryCategoriesResultsUrlState = () => {
  const [getTime] = (0, _use_kibana_timefilter_time.useKibanaTimefilterTime)(TIME_DEFAULTS);
  const {
    from: start,
    to: end
  } = getTime();
  const [timeRange, setTimeRange] = (0, _use_url_state.useUrlState)({
    defaultState: {
      startTime: start,
      endTime: end
    },
    decodeUrlState: value => (0, _pipeable.pipe)(urlTimeRangeRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity)),
    encodeUrlState: urlTimeRangeRT.encode,
    urlStateKey: TIME_RANGE_URL_STATE_KEY,
    writeDefaultState: true
  });
  (0, _use_kibana_timefilter_time.useSyncKibanaTimeFilterTime)(TIME_DEFAULTS, {
    from: timeRange.startTime,
    to: timeRange.endTime
  });
  const [autoRefresh, setAutoRefresh] = (0, _use_url_state.useUrlState)({
    defaultState: {
      isPaused: false,
      interval: 60000
    },
    decodeUrlState: value => (0, _pipeable.pipe)(autoRefreshRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity)),
    encodeUrlState: autoRefreshRT.encode,
    urlStateKey: AUTOREFRESH_URL_STATE_KEY,
    writeDefaultState: true
  });
  return {
    timeRange,
    setTimeRange,
    autoRefresh,
    setAutoRefresh
  };
};
exports.useLogEntryCategoriesResultsUrlState = useLogEntryCategoriesResultsUrlState;