"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RedirectToNodeDetail = exports.REDIRECT_NODE_DETAILS_TO_KEY = exports.REDIRECT_NODE_DETAILS_FROM_KEY = exports.REDIRECT_ASSET_DETAILS_KEY = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _url_state_storage_service = require("../../../common/url_state_storage_service");
var _use_metrics_time = require("../metrics/metric_detail/hooks/use_metrics_time");
var _constants = require("../../components/asset_details/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REDIRECT_NODE_DETAILS_FROM_KEY = exports.REDIRECT_NODE_DETAILS_FROM_KEY = 'from';
const REDIRECT_NODE_DETAILS_TO_KEY = exports.REDIRECT_NODE_DETAILS_TO_KEY = 'to';
const REDIRECT_ASSET_DETAILS_KEY = exports.REDIRECT_ASSET_DETAILS_KEY = 'assetDetails';
const getHostDetailSearch = queryParams => {
  const from = queryParams.get(REDIRECT_NODE_DETAILS_FROM_KEY);
  const to = queryParams.get(REDIRECT_NODE_DETAILS_TO_KEY);
  const assetDetailsParam = queryParams.get(REDIRECT_ASSET_DETAILS_KEY);
  return (0, _url_state_storage_service.replaceStateKeyInQueryString)(_constants.ASSET_DETAILS_URL_STATE_KEY, {
    ...(assetDetailsParam ? _rison.default.decode(assetDetailsParam) : undefined),
    dateRange: {
      from: from ? new Date(parseFloat(from)).toISOString() : undefined,
      to: to ? new Date(parseFloat(to)).toISOString() : undefined
    }
  })('');
};
const getNodeDetailSearch = queryParams => {
  const from = queryParams.get(REDIRECT_NODE_DETAILS_FROM_KEY);
  const to = queryParams.get(REDIRECT_NODE_DETAILS_TO_KEY);
  return (0, _use_metrics_time.replaceMetricTimeInQueryString)(from ? parseFloat(from) : NaN, to ? parseFloat(to) : NaN)('');
};
const RedirectToNodeDetail = () => {
  const {
    params: {
      nodeType,
      nodeId
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const location = (0, _reactRouterDom.useLocation)();
  const queryParams = new URLSearchParams(location.search);
  const search = nodeType === 'host' ? getHostDetailSearch(queryParams) : getNodeDetailSearch(queryParams);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/detail/${nodeType}/${nodeId}`,
      search,
      state: location.state
    }
  });
};
exports.RedirectToNodeDetail = RedirectToNodeDetail;